#ifndef _DEVICE_H_
#define _DEVICE_H_

#include <map>
#include <list>
#include "DevInfo.h"
#include "AutoLock.h"
#include "DevUserLogin.h"

class IDevUserLogin;
class IDevAlarm;
class IDevConfig;
class CDevChannel;
class CGUID;

typedef enum
{
	Status_Logout    = 0x0,
	Status_Login     = 0x1,
	Status_OnAlarm   = 0x2
} Dev_Status;

class CDevice
{
public:
	CDevice();
	CDevice(CDevInfo &devInfo);
	virtual ~CDevice();	
	bool AddDevChannel(const unsigned int lChannelIdx);
	bool RemoveDevChannel(CDevChannel *chn);
	bool RemoveDevChannel(const unsigned int lChannelIdx);
	CDevChannel *GetDevChannel(const unsigned int channelIdx);
	CDevInfo *GetDeviceInfo() { return &m_DevInfo; }
	const char *GetDevGuid();
	void SetDevGuid(const char *guid);
	const char *GetRegionGuid();
	void SetRegionGuid(const char *guid);
	int GetDevType() const { return m_DevInfo.GetDeviceType(); }
	IDevUserLogin *GetDevUserLogin(BOOL bNeedLog = TRUE);
	IDevAlarm *GetAlarm(BOOL ForceLogin = TRUE);
	IDevConfig  *GetDevConfig(BOOL ForceLogin = TRUE);
	BOOL StartRemoteRecord(LONG lChannelIdx, LONG lRecordType);
	BOOL StopRemoteRecord(LONG lChannelIdx);
	void SetDevInfo(CDevInfo &devInfo);
    int  IsWorking();
	int  GetDeviceStatus();
	BOOL StopWorking();
    BOOL StopRecording();
    BOOL Reboot();
	BOOL IsLogin();
    BOOL Logout();
	void SetAlarming(BOOL bOnAlarm);
	BOOL IsAlarming() { return m_bOnAlarm; }
    LONG StartVoiceCom(DWORD dwVoiceChan,BOOL bNeedCBNoEncData,fVoiceDataCallBack cbVoiceDataCallBack,void *pUser);
    BOOL StopVoiceCom();
	void SetNetworkType(int nNetworkType) {m_DevInfo.SetNetworkType(nNetworkType);}
	int GetNetworkType() {return m_DevInfo.GetNetworkType();}

private:
    bool CreateUserLogin();
    void DeleteUserLogin();
    bool AddDevChannel(CDevChannel *chn);
    BOOL IsChannelExist(LONG lChannelIdx);
    bool CreateAlarm();
    void DeleteAlarm();
    bool CreateConfig();
    void DeleteConfig();

    std::map<unsigned int, CDevChannel *> m_mapChannels;

    CDevInfo      m_DevInfo;
    IDevConfig    *m_DevConfig;
    IDevUserLogin *m_DevUserLogin;
    IDevAlarm     *m_Alarm;
	int           m_devStatus;
	BOOL          m_bOnAlarm;
	CCritSec      m_csLock;
};

typedef std::list<CDevChannel *> CDevChannelList;
typedef std::map<unsigned int, CDevChannel *>::iterator CMapDevChannelIterator;

#endif

